<?php
// insert-admin.php
// RUN ONCE to add a new admin user securely.

require_once __DIR__ . "/includes/config.php";


// ----------------------
// FORM HANDLING
// ----------------------
$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $email = trim($_POST["email"]);
    $password = trim($_POST["password"]);
    $username = trim($_POST["username"]);

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Invalid email address.";
    } elseif (strlen($password) < 6) {
        $message = "Password must be at least 6 characters.";
    } else {

        // If no username, generate one automatically
        if ($username === "") {
            $username = explode("@", $email)[0] . rand(100, 999);
        }

        // Check if email already exists
        $stmt = $pdo->prepare("SELECT id FROM admin_users WHERE email = ?");
        $stmt->execute([$email]);

        if ($stmt->rowCount() > 0) {
            $message = "This email already exists in the database.";
        } else {

            // Secure hashing
            $hashed = password_hash($password, PASSWORD_DEFAULT);

            $insert = $pdo->prepare("
                INSERT INTO admin_users (username, email, password)
                VALUES (?, ?, ?)
            ");

            if ($insert->execute([$username, $email, $hashed])) {

                $message = "Admin created successfully!<br>Email: <b>$email</b><br>Password: <b>$password</b>";

                // OPTIONAL: uncomment to auto-delete file after use
                // unlink(__FILE__);
            } else {
                $message = "Error inserting admin user.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Create Admin User</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: Arial; background: #f4f4f4; padding: 40px; }
        .box {
            max-width: 420px;
            margin: auto;
            padding: 20px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 0 10px #ccc;
        }
        input {
            width: 90%;
            padding: 12px;
            margin-top: 10px;
            border: 1px solid #ddd;
            border-radius: 6px;
        }
        button {
            margin-top: 12px;
            width: 100%;
            padding: 12px;
            border: none;
            background: #0073aa;
            color: white;
            font-size: 16px;
            border-radius: 6px;
            cursor: pointer;
        }
        button:hover { background: #005d88; }
        .msg {
            background: #eef;
            padding: 10px;
            margin-top: 15px;
            border-left: 4px solid #0073aa;
        }
    </style>
</head>
<body>

<div class="box">
    <h2>Create New Admin</h2>

    <?php if ($message): ?>
        <div class="msg"><?= $message ?></div>
    <?php endif; ?>

    <form method="POST">

        <input type="text" name="username" placeholder="Username (optional)">
        
        <input type="email" name="email" placeholder="Admin Email" required>

        <input type="password" name="password" placeholder="Password (min 6 chars)" required>

        <button>Create Admin</button>
    </form>
</div>

</body>
</html>
