<?php
require_once __DIR__ . "/../includes/auth.php";

// Already logged in
if (is_logged_in()) {
    header("Location: index.php");
    exit;
}

$error = "";

// If user is temporarily blocked
if (is_rate_limited()) {
    $error = "Too many failed attempts. Try again after 10 minutes.";
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && !$error) {
    $email = trim($_POST["email"] ?? "");
    $password = trim($_POST["password"] ?? "");

    if (login_admin($email, $password)) {
        header("Location: index.php");
        exit;
    } else {
        $error = "Invalid email or password.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Secure Admin Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: Arial; background: #f4f4f4; padding: 60px; }
        .login-box {
            max-width: 380px;
            margin: auto;
            background: white;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0 0 10px #ccc;
        }
        input {
            width: 90%;
            padding: 12px;
            margin-top: 10px;
            border: 1px solid #ddd;
            border-radius: 6px;
        }
        button {
            margin-top: 10px;
            width: 100%;
            padding: 12px;
            border: none;
            background: #0073aa;
            color: white;
            font-size: 16px;
            border-radius: 6px;
            cursor: pointer;
        }
        button:hover { background: #005d88; }
        .error { color: red; margin-top: 10px; }
    </style>
</head>
<body>
    <div class="login-box">

        <h2>Admin Login</h2>

        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST">
            <input type="email" name="email" placeholder="Email Address" required>
            <input type="password" name="password" placeholder="Password" required>
            <button>Sign In</button>
        </form>

    </div>
</body>
</html>
