<?php
// admin/delete-post.php
require_once '../includes/config.php';
require_once '../includes/auth.php';
requireLogin();

if (!isset($_GET['id'])) {
    header('Location: posts.php');
    exit();
}

$id = (int)$_GET['id'];

// Get post to delete image
$stmt = $pdo->prepare("SELECT featured_image FROM blog_posts WHERE id = ?");
$stmt->execute([$id]);
$post = $stmt->fetch();

// Delete featured image if exists
if ($post && $post['featured_image']) {
    $filepath = UPLOAD_DIR . $post['featured_image'];
    if (file_exists($filepath)) {
        unlink($filepath);
    }
}

// Delete post
$stmt = $pdo->prepare("DELETE FROM blog_posts WHERE id = ?");
$stmt->execute([$id]);

header('Location: posts.php?deleted=1');
exit();